from speedbeesynapse.component.base import HiveComponentBase, HiveComponentInfo, DataType
import math
import random

# Define the component class and it's information
@HiveComponentInfo(uuid='17514cd7-8e6b-485a-946e-c235375b9a0d', name='sin_and_rand', inports=0, outports=1)
class HiveComponent(HiveComponentBase):
    def main(self, param):
        try:
            sin_hz = float(param)
        except:
            sin_hz = 1.0
        count = 0

        # Create columns.
        self.sin = self.out_port1.Column('sin', DataType.DOUBLE)
        self.rand = self.out_port1.Column('rand', DataType.INT32)

        # Repeat at 100msec intervals.
        for [ts, skip] in self.interval_iteration(100000000):

            # Compute sin wave value and insert it into 'sin' column.
            val = math.sin(2*math.pi*sin_hz*count/10)
            self.sin.insert(val, ts)

            # Insert random value into 'rand' column only once in 10.
            if count % 10 == 0:
                self.rand.insert(random.randrange(0, 100), ts)

            count += 1
