# Sample for Creating Custom Components (C)

## English Version

### Sample for Creating Custom Components (C) with CMake

#### Contents

* Makefile
* countandrandom.c
* readandlog.c
* README.md

#### Build Instructions (Linux)

Place the directory containing this sample on a device where Synapse is installed.

Please install build tools such as GCC and make in advance.
In most environments, you can install them with the following command:
```
$ sudo apt install build-essential make
```

You can build the custom component samples with the following command:
```
$ cd {path_to_this_dir}
$ make
```

If the build is successful, the following two .so files will be generated:
* `hivecomp-countandrandom.so`
* `hivecomp-readandlog.so`

---

## 日本語版 (Japanese Version)

### CMakeによるカスタムコンポーネント(C)を作成するサンプル

#### 内容物

* Makefile
* countandrandom.c
* readandlog.c
* README.md

#### ビルド手順(Linux)

本サンプルを含むディレクトリをSynapseがインストールされたデバイス上に配置してください。

事前にGCC, makeなどのビルドツールをインストールしておいてください。
多くの環境では下記のコマンドでインストールできます。
```
$ sudo apt install build-essential make
```

下記コマンドでカスタムコンポーネントのサンプルをビルドできます。
```
$ cd {path_to_this_dir}
$ make
```

ビルドが成功すると、下記２つの.soファイルが生成されます。
* `hivecomp-countandrandom.so`
* `hivecomp-readandlog.so`

