#include <errno.h>
#include <hiveframework.h>
#include <stdio.h>
#include <string.h>
#ifdef _WIN32
#  include <Windows.h>
#else
#  include <unistd.h>
#endif

/********************************************************************/
/* Collector Implementation Example                                */
/********************************************************************/
static bool premain(HIVE_COMPONENT comp, const char *param, HIVE_STATUS status) {
  HIVE_LOG_INFO("premain called");
  return true;
}

static void postmain(HIVE_COMPONENT comp, const char *param) {
  HIVE_LOG_INFO("postmain called");
}

static bool mainloop(HIVE_COMPONENT comp, const char *param, HIVE_STATUS status) {
  HIVE_LOG_INFO("create columns");
  HIVE_OUTCOLUMN clm_count = hive_outport_create_column(comp, OUTPORT1, "count", HIVE_DATA_SCALAR(HIVE_TYPE_INT32), HIVE_COLUMN_OPTION_NONE);
  HIVE_OUTCOLUMN clm_random = hive_outport_create_column(comp, OUTPORT1, "random", HIVE_DATA_SCALAR(HIVE_TYPE_DOUBLE), HIVE_COLUMN_OPTION_NONE);

  int count = 1;
  while (hive_component_runnable(comp)) {
    HIVE_LOG_INFO("insert count");
    if (!hive_outcolumn_insert(clm_count, &count)) {
      HIVE_API_ERROR err = hive_get_api_error();
      HIVE_LOG_ERROR("insert 'count' failed: errcode=0x%08x", err.code);
    }

    HIVE_LOG_INFO("insert random");
    double r = 100 * (double)rand() / (double)RAND_MAX;
    if (!hive_outcolumn_insert(clm_random, &r)) {
      HIVE_API_ERROR err = hive_get_api_error();
      HIVE_LOG_ERROR("insert 'count' failed: errcode=0x%08x", err.code);
    }

#ifdef _WIN32
    Sleep(3000);
#else
    usleep(3000*1000);
#endif

    count++;
  }

  return true;
}

/* Collector definition data: describes name, description, parameters, and output data. */
const static HIVE_COMPONENT_DEFINITION info = {
  .uuid            = "2e80ad02-1730-4bdc-b321-2fbc2d1b942e",
  .name            = "count and random",
  .parameter_type  = HIVE_COMPONENT_PARAMETER_NONE,
  .in_ports        = 0,
  .out_ports       = 1,
  .functions     = {
    .constructor        = NULL,      // optional
    .premain            = premain,   // optional
    .main               = mainloop,  // required
    .postmain           = postmain,  // optional
    .destructor         = NULL,      // optional
    .stop               = NULL,      // optional
  },
};
EXPORT_COMPONENT_DEFINITION(info);

