# Sample for Creating Custom Components (C) with CMake

## English Version

### Sample for Creating Custom Components (C) with CMake

#### Contents

* CMakeLists.txt
* countandrandom.c
* readandlog.c
* README.md

#### Build Instructions (Linux)

Place the directory containing this sample on a device where Synapse is installed.

Please install build tools such as GCC and cmake in advance.
In most environments, you can install them with the following command:
```
$ sudo apt install build-essential cmake
```

You can build the custom component samples with the following command:
```
$ cd {path_to_this_dir}
$ mkdir build
$ cd build
$ cmake .. -DCMAKE_BUILD_TYPE=Release
$ cmake --build .
```

If the build is successful, the following two .so files will be generated:
* `hivecomp-countandrandom.so`
* `hivecomp-readandlog.so`

#### Build Instructions (Windows)

Place the directory containing this sample on a device where Synapse is installed.

Please install the following applications in advance:
* Visual Studio (2022 recommended)
* Visual Studio workload: Desktop development with C++
* Visual Studio workload: C++ CMake tools for Windows

After launching Visual Studio's command line tools (x64 Native Tools Command Prompt for VS 2022),
you can build the custom component samples with the following command:
```
> cd {path_to_this_dir}
> mkdir build
> cd build
> cmake ..
> cmake --build . --config release
```

If the build is successful, the following two .dll files will be generated:
* `build\Release\hivecomp-countandrandom.dll`
* `build\Release\hivecomp-readandlog.dll`

---

## 日本語版 (Japanese Version)

### CMakeによるカスタムコンポーネント(C)を作成するサンプル

#### 内容物

* CMakeLists.txt
* countandrandom.c
* readandlog.c
* README.md

#### ビルド手順(Linux)

本サンプルを含むディレクトリをSynapseがインストールされたデバイス上に配置してください。

事前にGCC, cmakeなどのビルドツールをインストールしておいてください。
多くの環境では下記のコマンドでインストールできます。
```
$ sudo apt install build-essential cmake
```

下記コマンドでカスタムコンポーネントのサンプルをビルドできます。
```
$ cd {path_to_this_dir}
$ mkdir build
$ cd build
$ cmake .. -DCMAKE_BUILD_TYPE=Release
$ cmake --build .
```

ビルドが成功すると、下記２つの.soファイルが生成されます。
* `hivecomp-countandrandom.so`
* `hivecomp-readandlog.so`

#### ビルド手順(Windows)

本サンプルを含むディレクトリをSynapseがインストールされたデバイス上に配置してください。

事前に下記のアプリケーション等をインストールしてください。
* Visual Studio (2022推奨)
* Visual Studioのワークロード C++によるデスクトップ開発
* Visual Studioのワークロード C++によるデスクトップ開発 Windows用 C++ CMakeツール

Visual Studioのコマンドラインツール(x64 Native Tools Command Prompt for VS 2022)を立ち上げたあと、
下記コマンドでカスタムコンポーネントのサンプルをビルドできます。
```
> cd {path_to_this_dir}
> mkdir build
> cd build
> cmake ..
> cmake --build . --config release
```

ビルドが成功すると、下記２つの.dllファイルが生成されます。
* `build\Release\hivecomp-countandrandom.dll`
* `build\Release\hivecomp-readandlog.dll`

