from speedbeesynapse.component.base import HiveComponentBase, HiveComponentInfo, DataType, HiveApiError
import datetime


# Define the component class and it's information.
@HiveComponentInfo(uuid='daafcb03-820b-4c1b-acfb-266c31186803', name='read_and_log', inports=1, outports=1)
class HiveComponent(HiveComponentBase):

    def main(self, param):
        # Create a column for logging received data.
        self.logclm = self.out_port1.Column('log', DataType.STRING)

        # Logging column information received from 'in_port1'.
        columns = self.in_port1.get_columns()
        for column in columns:
            self.log.info(column)

        # Start receving column values from 'in_port1'.
        with self.in_port1.ContinuousReader(start=self.get_timestamp()) as reader:
            # Loop until the component received 'stop' request.
            while self.is_runnable():
                # Get a group of records of column data (called as window_data).
                window_data = reader.read()
                if not window_data:
                    # window_data may be None.
                    self.log.info("no data yet")
                    continue

                # Process all records in a window_data one by one.
                for record in window_data.records:
                    # Convert timestamp as a string.
                    ts = datetime.datetime.fromtimestamp(record.timestamp / 1000000000)

                    # Process all column's value in a record one by one.
                    for columnvalue in record.data:
                        if columnvalue.value:
                            # Make string from columnvalue, logging it and insert it into the column
                            logmsg = f"{columnvalue.column}[{str(ts)}]: {columnvalue.value}"
                            self.log.info(logmsg)
                            try:
                                self.logclm.insert(logmsg, record.timestamp)
                            except HiveApiError as e:
                                self.log.error(e)
                        else:
                            pass  # ignore None
